/*******************************************************
Filename		:  FA_REGULAR_RESULT_data2.sql
Release 		:  c2.0
SIR			:  1497, 1614, 1619
Description		:  Adds additional data element to the FA_REGULAR_RESULT fact table.
Author			:  Joseph Wilson/Ganesh Thadkamalla
Date			:  3/28/2003
			   4/2003 - Edited to replace some org_id columns with organization_id --GAnesh.
			   7-01-2003 --changed names from CHEM to REGULAR; added new 2.0 columns and removed outdated -JW
			   7-03-2003 --updated dates to single date/time values -JW
			   7-10-2003 --added units to detection_limit -JW
			   7-15-2003 --added SAMPLE_FRACTION_TYPE -JW
			   7-16-2003 --added CAS # and ITIS # -JW
			   7-21-2003 --added new sample pres elements; changed name to SGO indicator -JW
			   7-29-2003 --added EPA REG # -JW
			   8-04-2003 --updated result comment and text result to user long_temp table; updated field_set -JW
			   8-11-2003 --updated SAMPLE PRES ELEMENTS update -JW
                     	   8-13-2003 --added logic to set activity attributes for 'Composite-with Parents' samples. -C Tsang
			   1-07-2004 --added station location point information (new fk to fa_station) -JW
			   1/16/2004 --SIR 1586 Moved connect string to master install script -JW
			   1/22/2004 --removed sublogs and added echo command -JW
			   5/18/2004 --added unit conversion update -JW
			   5/24/2004 --combined UOM and conversion updates to improve performance -JW
			   6/09/2004 - added std datum columns updates. -GT
			   6/18/2004 --updated char alias update logic to improve performance -JW
			   6/21/2004 --updated unit conversion to user result_value_text and to test 0 values -JW
			   8/28/2004 --change tsruom_is_number to FK_UNIT_CONVERSION -JW
			   8/10/2004 --updated char alias code to use tsrcalt table -JW
Comments		:  new version of this script that uses seperate update statements at the table level.  This was done to reduce the number of update statements to improve performance time.  
**********************************************************/
spool FA_REGULAR_RESULT_data2.log
set serveroutput on
set time on
set echo on

SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
--CHAR (RE-WRITE TO USE DI_CHARACTERISTIC TABLE)
UPDATE FA_REGULAR_RESULT RE SET CHARACTERISTIC_NAME =
	(SELECT CHR.DISPLAY_NAME	
	FROM storet.TSRCHAR CHR
	WHERE re.FK_CHAR = CHR.TSRCHAR_IS_NUMBER
	AND re.TSRCHAR_ORG_ID = CHR.TSRCHAR_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--PARTICLE SIZE
UPDATE FA_REGULAR_RESULT RE SET PARTICLE_SIZE =
	(SELECT RCI.PARTICLE_SIZE_BASIS
	FROM storet1.TSRRCI RCI
	WHERE re.result_is_number = RCI.TSRRSULT_IS_NUMBER
	AND re.ORGANIZATION_ID = RCI.TSRRSULT_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--trip and station visit info
UPDATE FA_REGULAR_RESULT RE 
SET (STATION_ID,STATION_NAME,TRIP_ID,TRIP_NAME,STATION_VISIT_ID,TSMSTATN_IS_NUMBER,
     VISIT_START_DATE_TIME,VISIT_START_TIME_ZONE,VISIT_STOP_DATE_TIME,VISIT_STOP_TIME_ZONE) =
(SELECT st.STATION_ID,st.STATION_NAME,st.TRIP_ID,st.TRIP_NAME,st.STATION_VISIT_ID,st.TSMSTATN_IS_NUMBER,
	st.VISIT_START_DATE_TIME,st.VISIT_START_TIME_ZONE,st.VISIT_STOP_DATE_TIME,st.VISIT_STOP_TIME_ZONE	
  	from statninfo_temp st
  	WHERE re.TSRSTVST_IS_NUMBER = ST.TSRSTVST_IS_NUMBER
	AND re.ORGANIZATION_ID = ST.TSRSTVST_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--STATION and STATION LOCATION INFO  (updated on 06-09-04)
update FA_REGULAR_RESULT re set (fk_station,
		re.fk_org, 
		re.fk_db_cat,
		re.fk_geo_county,
		re.fk_geo_state,
		re.fk_mad_hdatum,
		re.fk_mad_hmethod,
		re.stn_latitude,
		re.stn_longitude,
                re.stn_hdatum,
                re.stn_std_latitude,
                re.stn_std_longitude,
                re.stn_std_hdatum,
		re.hydrologic_unit_code,
		re.sgo_indicator)=
	(select st.pk_isn,
		st.fk_org,
		st.fk_db_cat,
		st.fk_geo_county,
		st.fk_geo_state,
		st.fk_mad_hdatum,
		st.fk_mad_hmethod,
		st.latitude,
		st.longitude,
                stn_hd.id_code,
                st.std_latitude,
                st.std_longitude,
                stn_std_hd.id_code,
		st.hydrologic_unit_code,
		st.sgo_indicator
	from fa_station st,
             lu_mad_hdatum stn_hd,
             lu_mad_hdatum stn_std_hd
	where st.organization_id = re.organization_id
	and st.station_is_number = re.tsmstatn_is_number
        and st.fk_mad_hdatum = stn_hd.pk_isn (+)
	and st.fk_std_hdatum = stn_std_hd.pk_isn (+)
	and st.location_point_type = '*POINT OF RECORD');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
/**
--RESULT UOM
UPDATE FA_REGULAR_RESULT RE SET RESULT_UNIT =
	(SELECT RSLTUOM.SHORT_FORM_NAME
	FROM storet.TSRUOM RSLTUOM
	WHERE re.TSRUOM_IS_NUMBER = RSLTUOM.TSRUOM_IS_NUMBER
  	AND re.TSRUOM_ORG_ID = RSLTUOM.TSRUOM_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--STD unit and value
UPDATE FA_REGULAR_RESULT RE
	SET (STD_VALUE,STD_UNIT) = (SELECT CASE tsruom_is_number 
		WHEN 201 THEN (RE.RESULT_VALUE - 32) * conversion_factor 
		WHEN 202 THEN (RE.RESULT_VALUE - 273.15)
		ELSE RESULT_VALUE * conversion_factor END, target_unit
	from lu_unit_conversion uc
	where tsruom_is_number = uc.pk_isn);
commit;

--updated 06-21-2004
UPDATE FA_REGULAR_RESULT RE
	SET (RESULT_UNIT,STD_VALUE,STD_UNIT) = (SELECT SHORT_FORM_NAME, CASE tsruom_is_number 
		WHEN 201 THEN (RE.RESULT_VALUE - 32) * conversion_factor 
		WHEN 202 THEN (RE.RESULT_VALUE - 273.15)
		ELSE RESULT_VALUE * conversion_factor END, target_unit
	from lu_unit_conversion uc
	where tsruom_is_number = uc.pk_isn);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
**/
--Populate Result Unit, STD unit and STD value columns
--account for temperature conversion shift for F and K (tsruom_is_Number 201 and 202) to C
--use result_value if result_value_text is not a valid number
--std value should not be 0 when result_value is 0 but result_value_text is blank
UPDATE FA_REGULAR_RESULT RE
	SET (RESULT_UNIT,STD_VALUE,STD_UNIT) = (SELECT SHORT_FORM_NAME, CASE FK_UNIT_CONVERSION 
		WHEN 201 THEN (RE.RESULT_VALUE - 32) * conversion_factor 
		WHEN 202 THEN (RE.RESULT_VALUE - 273.15)
		ELSE (CASE WHEN ((length(ltrim(rtrim(result_value_text,'0123456789-+. '),'0123456789-+. ')) > 0) OR
			length(ltrim(rtrim(result_value_text,'-+. '),'-+. ')) is null) AND	
			result_value_text <> ' ' THEN result_value ELSE
			to_number(ltrim(rtrim(result_value_text))) END) * conversion_factor END, target_unit
	from lu_unit_conversion uc
	where FK_UNIT_CONVERSION = uc.pk_isn);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--activity attributes
-- 01-07-2004 - added tsmalp_is_number
--06-09-2004 - added std_datum info.
update FA_REGULAR_RESULT RE
set (LOCATION_POINT_TYPE    ,
tsmalp_is_number,
POINT_SEQUENCE_NUMBER  ,
WELL_NUMBER            ,
PIPE_NUMBER            ,
ACTIVITY_LATITUDE      ,
ACTIVITY_LONGITUDE     ,
FK_ACT_MAD_HDATUM      ,
FK_ACT_MAD_HMETHOD     ,
ACT_STD_LATITUDE       ,
ACT_STD_LONGITUDE      ,
act_STD_HDATUM  ,
activity_isn		,
POINT_NAME			,
MAP_SCALE) =  
(select b.LOCATION_POINT_TYPE    ,
b.tsmalp_is_number,
b.POINT_SEQUENCE_NUMBER  ,
b.WELL_NUMBER            ,
b.PIPE_NUMBER            ,
b.ACTIVITY_LATITUDE      ,
b.ACTIVITY_LONGITUDE     ,
b.FK_ACT_MAD_HDATUM      ,
b.FK_ACT_MAD_HMETHOD     ,
b.ACT_STD_LATITUDE       ,
b.ACT_STD_LONGITUDE      ,
b.act_STD_HDATUM  ,
b.activity_isn		,
b.POINT_NAME			,
b.MAP_SCALE
from fdact_temp2 b
where re.activity_is_number = b.activity_is_number
and  re.organization_id = b.organization_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

-- activity attributes for ACTIVITY CATEGORY='Composite-with Parents'
-- set to the station location (updated on 06-09-2004)
update FA_REGULAR_RESULT re 
set (re.location_point_type,
     re.point_sequence_number,
     re.point_name,
     re.activity_latitude,
     re.activity_longitude,
     re.act_std_latitude,         --6/10/04
     re.act_std_longitude,        --6/10/04
     re.act_STD_HDATUM,    --6/10/04
     re.map_scale,
     re.fk_act_mad_hdatum,
     re.fk_act_mad_hmethod) =
(select st.location_point_type,
     st.point_sequence_number,
     st.point_name,
     st.latitude,
     st.longitude,
     st.std_latitude,          --6/10/04
     st.std_longitude,         --6/10/04
     hd.id_code,    --st.fk_std_hdatum,     --6/10/04
     st.map_scale,
     st.fk_mad_hdatum,
     st.fk_mad_hmethod
 from fa_station st,
      lu_mad_hdatum hd
 where st.organization_id = re.organization_id
 and st.station_is_number = re.tsmstatn_is_number
 and st.fk_std_hdatum = hd.pk_isn (+)
 and st.location_point_type = '*POINT OF RECORD')
where re.activity_category = 'Composite-with Parents';
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--ANALYTICAL PROCEDURE
UPDATE FA_REGULAR_RESULT RE SET (ANALYTICAL_PROCEDURE_SOURCE,ANALYTICAL_PROCEDURE_ID) =
	(SELECT ANLPR.SOURCE_ACR,
		ANLPR.PROCEDURE_ID	
	FROM storet1.TSRANLPR ANLPR
	WHERE re.TSRANLPR_IS_NUMBER = ANLPR.TSRANLPR_IS_NUMBER
	AND re.TSRANLPR_ORG_ID = ANLPR.TSRANLPR_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

/**
--SAMPLE PREP
UPDATE FA_REGULAR_RESULT RE SET (SAMPLE_PREP_SOURCE,SAMPLE_PREP_NAME) =
	(SELECT LSPP.SOURCE_ACR,
		LSPP.NAME
	FROM storet1.TSRLSPP LSPP
	WHERE re.TSRLSPP_IS_NUMBER = LSPP.TSRLSPP_IS_NUMBER
	AND re.TSRLSPP_ORG_ID = LSPP.TSRLSPP_ORG_ID);
commit;
**/

--LAB
UPDATE FA_REGULAR_RESULT RE SET (LAB_ID,LAB_NAME) =
	(SELECT LAB.ID_CODE,
		LAB.NAME
	FROM storet1.TSRLAB LAB
	WHERE re.TSRLAB_IS_NUMBER = LAB.TSRLAB_IS_NUMBER
	AND re.ORGANIZATION_ID= LAB.TSRLAB_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--QUANT LIMITS
UPDATE FA_REGULAR_RESULT RE SET (LOWER_QUANTITATION_LIMIT,UPPER_QUANTITATION_LIMIT,DETECTION_LIMIT,
 	DETECTION_LIMIT_DESCRIPTION) =
 	(SELECT DQL.MIN_QUANT_LIMIT,
  		DQL.MAX_QUANT_LIMIT,
  		DQL.MIN_DETECT_LIMIT||' '||UOM.SHORT_FORM_NAME,
  		DQL.DESCRIPTION_TEXT
 	FROM storet1.TSRDQL DQL, storet.TSRUOM UOM
 	WHERE re.RESULT_IS_NUMBER = DQL.TSRRSULT_IS_NUMBER
 		AND re.ORGANIZATION_ID = DQL.TSRRSULT_ORG_ID
 		AND DQL.TSRUOM_IS_NUMBER = UOM.TSRUOM_IS_NUMBER
 		AND DQL.TSRUOM_ORG_ID = UOM.TSRUOM_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--FK_DATE
update FA_REGULAR_RESULT re set fk_date_act_start = (
	select da.pk_isn from di_date da
	where TO_CHAR(re.activity_start_date_time,'DD-MON-YYYY') = da.full_date);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--** new Activity Elements section **
--FIELD PROCEDURE
update FA_REGULAR_RESULT re
set (field_procedure_id) = (
	select id_code
	from storet1.TSRFLDPR fldpr
	where re.tsrfldpr_is_number = fldpr.tsrfldpr_is_number
	and re.ORGANIZATION_ID = fldpr.tsrfldpr_org_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

/**
--SAMPLE
update FA_REGULAR_RESULT re
set (container_type,container_color,temperature_presrvtn_type,presrvtn_storage_procedure) = (
	select container_type_nm,container_color,temp_preservn_type,presrv_strge_prcdr
	from storet1.tsrsmple smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;
**/

--GEAR CONFIG
update FA_REGULAR_RESULT re
set (gear_config_id) = (
	select id_code
	from storet1.tsrgrcfg grcfg
	where re.tsrgrcfg_is_number = grcfg.tsrgrcfg_is_number
	and re.ORGANIZATION_ID = grcfg.tsrgrcfg_org_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--FIELD GEAR ID
update FA_REGULAR_RESULT re
set (field_gear_id) = (
	select id_code
	from storet.tsrfldgr fldgr
	where re.tsrfldgr_is_number = fldgr.tsrfldgr_is_number);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--ACTIVITY MATRIX
update FA_REGULAR_RESULT re
set (re.activity_matrix) = (
	select matrx.name
	from storet.tsrmatrx matrx
	where re.tsrmatrx_is_number = matrx.tsrmatrx_is_number);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--GNTXT FIELDS
update FA_REGULAR_RESULT re
set (re.result_comment) = (
	select long_text
	from long_temp lt
	where lt.organization_id = re.organization_id
		AND lt.result_is_number = re.result_is_number
		AND lt.long_type ='RSLTCMNT');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

update FA_REGULAR_RESULT re
set (re.text_result) = (
	select long_text
	from long_temp lt
	where lt.organization_id = re.organization_id
		AND lt.result_is_number = re.result_is_number
		AND lt.long_type ='DESCRIPT');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

-- Lab Remarks
update FA_REGULAR_RESULT a
set a.LAB_REMARK= (select b.lbrmk from lbrmk_temp b
       where b.tsrrsult_is_number = a.result_is_number
           and b.tsrrsult_org_id = a.organization_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

-- FIELD SET
update FA_REGULAR_RESULT a
set a.field_set= (select b.field_set from fieldset_temp b
       where a.activity_is_number = b.activity_is_number
	and a.organization_id = b.organization_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

-- NEW v2.0 SAMPLE_FRACTION_TYPES
update FA_REGULAR_RESULT re
set (SAMPLE_FRACTION_TYPE) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = re.tsmprmvl_is_number 
           and b.field_name = 'SMPL_FRAC_TYPE_NM'
           and b.table_name = 'TSRRSULT')
WHERE re.TSMPRMVL_IS_NUMBER IS NOT NULL;
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--CHARACTERISTIC ALIASES
/**
update FA_REGULAR_RESULT re
set ITIS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'ITIS TAXON SERIAL NUMBER');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

update FA_REGULAR_RESULT re
set CAS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'CAS NUMBER');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--EPA registry num
update FA_REGULAR_RESULT re
set EPA_REG_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
**/

alter table di_characteristic add cas_number varchar2(500); 
alter table di_characteristic add epa_reg_number varchar2(500); 
alter table di_characteristic add itis_number varchar2(500);

update di_characteristic
set ITIS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als, storet.TSRCALT calt 
     where pk_isn = als.tsrchar_is_number
	and als.tsrcalt_is_number = calt.tsrcalt_is_number
	and als.tsrcalt_org_id = calt.tsrcalt_org_id
	and calt.type_name = 'ITIS TAXON SERIAL NUMBER');

update di_characteristic
set CAS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als, storet.TSRCALT calt 
     where pk_isn = als.tsrchar_is_number
	and als.tsrcalt_is_number = calt.tsrcalt_is_number
	and als.tsrcalt_org_id = calt.tsrcalt_org_id
	and calt.type_name = 'CAS NUMBER');

update di_characteristic
set EPA_REG_NUMBER = (
     select NAME 
     from storet.TSRCHALS als, storet.TSRCALT calt 
     where pk_isn = als.tsrchar_is_number
	and als.tsrcalt_is_number = calt.tsrcalt_is_number
	and als.tsrcalt_org_id = calt.tsrcalt_org_id
	and calt.type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;

SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
UPDATE FA_REGULAR_RESULT RE SET (CHARACTERISTIC_NAME, cas_number, epa_reg_number, itis_number) =
	(SELECT display_name, cas_number, epa_reg_number, itis_number
	FROM di_characteristic CHR
	WHERE re.FK_CHAR = CHR.pk_isn);
commit;

alter table di_characteristic drop column cas_number;
alter table di_characteristic drop column epa_reg_number;
alter table di_characteristic drop column itis_number;

--SAMPLE PRES ELEMENTS
update FA_REGULAR_RESULT re
set (container_desc,TEMP_PRESERVN_TYPE,presrv_strge_prcdr) = (
	select container_desc,TEMP_PRESERVN_TYPE,presrv_strge_prcdr
	from sample_pres_temp smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--Populate station location point information (updated 01-07-2004)
update fa_regular_result re
set (fk_stn_act_pt) = (
	select pk_isn
	from fa_station st
	where re.tsmalp_is_number = st.tsmalp_is_number
	and re.organization_id = st.organization_id);

commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

update fa_regular_result re
set (fk_stn_act_pt) = (fk_station)
where fk_stn_act_pt is null;
commit;

spool off
set echo off